% Function: This program is used to create a cell array where each entry is
% string listing for each of the IP/Probe combinations in the experiment

% Inputs:
% ProbeLabels - a cell array where each entry is the name of a probe 
%    target
% IPLabels - a cell array where each entry is the name of an IP target

% Outputs:
% Labels - cell array where each entry is string listing each of the 
%    IP/Probe combinations

function [Labels] = LabelListFormat(ProbeLabels,IPLabels)

row = length(ProbeLabels);
col = length(IPLabels);

Labels = cell(row*col,1);

% loop over the rows (probes)
for j=1:row
    
    % loop over the col (IPs)
    for i=1:col 
       
        % define the next position in the label cell as the following
        % string 'ith Probe Label' + '_' + 'jth IP Label'
        Labels{(i-1)*row+j}= strcat(IPLabels{i},'_',ProbeLabels{j});
        
    end
end